###############################################################################
# OpenVAS Vulnerability Test
# $Id: mahara_multiple_vuln.nasl 8231 2010-06-29 11:53:19Z mime $
#
# Mahara Multiple vulnerabilities
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100334);
 script_bugtraq_id(36893,36892);
 script_cve_id("CVE-2009-3298,CVE-2009-3299");
 script_version ("1.0-$Revision: 8231 $");
 script_tag(name:"cvss_base", value:"6.5");
 script_tag(name:"risk_factor", value:"High");

 script_name("Mahara Multiple vulnerabilities");

desc = "Overview:
Mahara is prone to a security-bypass vulnerability and to a to a
cross-site scripting vulnerability.

An attacker can exploit this issue to reset the application's
administrator password or to execute arbitrary script code in the
browser of an unsuspecting user in the context of the affected site.

Versions prior to Mahara 1.0.13 and 1.1.7 are affected.

Solution:
The vendor has released updates. Please see the references for
details.

References:
http://www.securityfocus.com/bid/36893
http://www.securityfocus.com/bid/36892
http://wiki.mahara.org/Release_Notes/1.1.7
http://mahara.org/
http://mahara.org/interaction/forum/topic.php?id=1169
http://mahara.org/interaction/forum/topic.php?id=1170

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Mahara is prone to Multiple Vulnerabilities");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("secpod_mahara_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("http_keepalive.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/Mahara")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_in_range(version: vers, test_version: "1.0", test_version2: "1.0.12") ||
     version_in_range(version: vers, test_version: "1.1", test_version2: "1.1.6")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
