###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_vmware_prdts_detect_lin.nasl 0276 2008-09-23 11:00:14Z sep $
#
# VMware products version detection (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800001);
  script_version("$Revision: 7732 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("VMware products version detection (Linux)");
  desc ="
  Overview : This script retrieves all VMware Products version and saves those
  in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Get/Set the versions of VMware Products");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("General");
  exit(0);
}


include("ssh_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

version = ssh_cmd(socket:sock, cmd:"vmware -v", timeout:120);

if("VMware GSX Server" >< version)
{
  gsxVer = ereg_replace(string:version, replace:"\1",
                        pattern:".*VMware GSX Server ([0-9].*) build.*");
  gsxBuild = ereg_replace(string:version, replace:"\1",
                          pattern:".*VMware GSX Server [0-9].* build-([0-9]+).*");

  set_kb_item(name:"VMware/GSX-Server/Linux/Ver", value:gsxVer);
  set_kb_item(name:"VMware/GSX-Server/Linux/Build", value:chomp(gsxBuild));
  set_kb_item(name:"VMware/Linux/Installed", value:TRUE);
  security_note(data:"VMware GSX Server version " + gsxVer +
                                                 " was detected on the host");

  ssh_close_connection();
  exit(0);
}

else if("VMware Workstation" >< version)
{
  wrkstnVer = ereg_replace(string:version, replace:"\1",
                           pattern:".*VMware Workstation ([0-9].*) build.*");
  wrkstnBuild = ereg_replace(string:version, replace:"\1",
                             pattern:".*VMware Workstation [0-9].* build-([0-9]+).*");

  set_kb_item(name:"VMware/Workstation/Linux/Ver", value:wrkstnVer);
  set_kb_item(name:"VMware/Workstation/Linux/Build", value:chomp(wrkstnBuild));
  set_kb_item(name:"VMware/Linux/Installed", value:TRUE);
  security_note(data:"VMware Workstation version " + wrkstnVer +
                                                 " was detected on the host");

  ssh_close_connection();
  exit(0);
}

else if("VMware Server" >< version)
{
  svrVer = ereg_replace(string:version, replace:"\1",
                        pattern:".*VMware Server ([0-9].*) build.*");
  svrBuild = ereg_replace(string:version, replace:"\1",
                          pattern:".*VMware Server [0-9].* build-([0-9]+).*");

  set_kb_item(name:"VMware/Server/Linux/Ver", value:svrVer);
  set_kb_item(name:"VMware/Server/Linux/Build", value:chomp(svrBuild));
  set_kb_item(name:"VMware/Linux/Installed", value:TRUE);
  security_note(data:"VMware Server version " + svrVer +
                                       " was detected on the host");

  ssh_close_connection();
  exit(0);
}

version = ssh_cmd(socket:sock, cmd:"vmplayer -v", timeout:120);
if(!isnull(version) && (version !~ "vmplayer.* not found"))
{
  version = ssh_cmd(socket:sock, timeout:120,
                    cmd:"cat /usr/bin/vmware-config.pl | grep -ir ' build-'");
  playerVer = ereg_replace(pattern:".*'([0-9.]+) .*", string:version, replace:"\1");
  playerBuild = ereg_replace(pattern:".*-([0-9]+)'.*", string:version, replace:"\1");
  set_kb_item(name:"VMware/Player/Linux/Ver", value:playerVer);
  set_kb_item(name:"VMware/Player/Linux/Build", value:chomp(playerBuild));
  set_kb_item(name:"VMware/Linux/Installed", value:TRUE);
  security_note(data:"VMware Player version " + playerVer +
                                                " was detected on the host");
}
ssh_close_connection();
