###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for compiz vulnerability USN-537-2
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840019);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.2");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "537-2");
  script_cve_id("CVE-2007-3920");
  script_name( "Ubuntu Update for compiz vulnerability USN-537-2");
  desc = "

  Vulnerability Insight:

  USN-537-1 fixed vulnerabilities in gnome-screensaver. The fixes were
  incomplete, and only reduced the scope of the vulnerability, without
  fully solving it. This update fixes related problems in compiz.
  
  Original advisory details:
  
  Jens Askengren discovered that gnome-screensaver became confused when
  running under Compiz, and could lose keyboard lock focus. A local attacker
  could exploit this to bypass the user's locked screen saver.

  Affected Software/OS:
  compiz vulnerability on Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-November/000618.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of compiz vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"compiz-core", ver:"0.6.0+git20071008-0ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"compiz-dev", ver:"0.6.0+git20071008-0ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"compiz-gnome", ver:"0.6.0+git20071008-0ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"compiz-plugins", ver:"0.6.0+git20071008-0ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdecoration0-dev", ver:"0.6.0+git20071008-0ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libdecoration0", ver:"0.6.0+git20071008-0ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"compiz-kde", ver:"0.6.0+git20071008-0ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"compiz", ver:"0.6.0+git20071008-0ubuntu1.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}