###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for util-linux vulnerability USN-533-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840002);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.9");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "533-1");
  script_cve_id("CVE-2007-5191");
  script_name( "Ubuntu Update for util-linux vulnerability USN-533-1");
  desc = "

  Vulnerability Insight:

  Ludwig Nussel discovered that mount and umount did not properly
  drop privileges when using helper programs. Local attackers may be
  able to bypass security restrictions and gain root privileges using
  programs such as mount.nfs or mount.cifs.

  Affected Software/OS:
  util-linux vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-October/000610.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of util-linux vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"bsdutils", ver:"2.12r-17ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mount", ver:"2.12r-17ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"util-linux", ver:"2.12r-17ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"util-linux-locales", ver:"2.12r-17ubuntu2.1", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"bsdutils", ver:"2.12r-4ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mount", ver:"2.12r-4ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"util-linux", ver:"2.12r-4ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"util-linux-locales", ver:"2.12r-4ubuntu6.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"bsdutils", ver:"2.12r-11ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mount", ver:"2.12r-11ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"util-linux", ver:"2.12r-11ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"util-linux-locales", ver:"2.12r-11ubuntu2.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}