###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_slysoft_prdts_code_exec_vuln.nasl 962 2009-03-19 19:16:29Z mar $
#
# SlySoft Product(s) Code Execution Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800392);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.9");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-0824");
  script_bugtraq_id(34103);
  script_name("SlySoft Product(s) Code Execution Vulnerability");
  desc = "

  Overview: This host is installed with SlySoft Product(s) and are prone
  to Code Execution Vulnerability.

  Vulnerability Insight:
  METHOD_NEITHER communication method for IOCTLs does not properly validate
  a buffer associated with the Irp object of user space data provided to
  the ElbyCDIO.sys kernel driver.

  Impact:
  Successful exploitation will let the attacker cause memory corruption and
  can allow remote code execution in the context of the affected system,
  which result in service crash.

  Impact Level: System/Application

  Affected Software/OS:
  SlySoft AnyDVD version prior to 6.5.2.6
  SlySoft CloneCD version 5.3.1.3 and prior
  SlySoft CloneDVD version 2.9.2.0 and prior
  SlySoft Virtual CloneDrive version 5.4.2.3 and prior

  Fix: Upgrade to higher versions accordingly
  http://www.slysoft.com/en/download.html

  References:
  http://secunia.com/advisories/34269
  http://secunia.com/advisories/34289
  http://secunia.com/advisories/34287
  http://secunia.com/advisories/34288
  http://www.securityfocus.com/archive/1/archive/1/501713/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 4.9 (AV:L/AC:L/Au:NR/C:N/I:N/A:C)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of SlySoft Product(s)");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_slysoft_prdts_detect.nasl");
  script_require_keys("AnyDVD/Ver", "CloneCD/Ver", "CloneDVD/Ver",
                      "VirtualCloneDrive/Ver");
  exit(0);
}


include("version_func.inc");

# Grep the version for AnyDVD prior to 6.5.2.6
anydvdVer = get_kb_item("AnyDVD/Ver");
if(anydvdVer)
{
  if(version_is_less(version:anydvdVer, test_version:"6.5.2.6"))
  {
    security_warning(0);
    exit(0);
  }
}

# Grep the version for CloneCD 5.3.1.3 and prior
clonecdVer = get_kb_item("CloneCD/Ver");
if(clonecdVer)
{
  if(version_is_less_equal(version:clonecdVer, test_version:"5.3.1.3"))
  {
    security_warning(0);
    exit(0);
  }
}

# Grep the version for CloneDVD 2.9.2.0 and prior
clonedvdVer = get_kb_item("CloneDVD/Ver");
if(clonedvdVer)
{
  if(version_is_less_equal(version:clonedvdVer, test_version:"2.9.2.0"))
  {
    security_warning(0);
    exit(0);
  }
}

# Grep the version for Virtual CloneDrive 5.4.2.3 and prior
vcdVer = get_kb_item("VirtualCloneDrive/Ver");
if(vcdVer)
{
  if(version_is_less_equal(version:vcdVer, test_version:"5.4.2.3")){
    security_warning(0);
  }
}
