###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_shareaza_update_notification_spoof_vuln.nasl 4511 2009-09-10 23:02:12Z sep $
#
# Shareaza Update Notification Spoofing Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800604);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-7164");
  script_bugtraq_id(27171);
  script_name("Shareaza Update Notification Spoofing Vulnerability");
  desc = "
  Overview: This host has Shareaza installed and is prone Update Notification
  Spoofing vulnerabilities.

  Vulnerability Insight:
  The flaw is due to update notifications being handled via the domain
  update.shareaza.com, which is no longer controlled by the vendor. This can
  be exploited to spoof update notifications.

  Impact:
  Successful exploitation will let the attackers conduct spoofing attacks.

  Impact Level: Application

  Affected Software/OS:
  Shareaza version prior to 2.3.1.0

  Fix: Upgrade Shareaza version to 2.3.1.0
  http://shareaza.sourceforge.net/?id=download

  References:
  http://secunia.com/advisories/28302
  http://xforce.iss.net/xforce/xfdb/39484
  http://sourceforge.net/project/shownotes.php?group_id=110672&release_id=565250

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Shareaza");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_shareaza_detect.nasl");
  script_require_ports("Services/www", 6346);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

shareazaPort = get_http_port(default:6346);

if(!shareazaPort){
  exit(0);
}

shareazaVer = get_kb_item("www/" + shareazaPort + "/Shareaza");

if(shareazaVer != NULL)
{
  # Check for Shareaza versions prior to 2.3.1.0
  if(version_is_less(version:shareazaVer, test_version:"2.3.1.0")){
    security_hole(shareazaPort);
  }
}
