###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_rhinosoft_serv-u_detect.nasl 5238 2009-10-20 22:02:29Z oct $
#
# Rhino Software Serv-U Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801117);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Rhino Software Serv-U Version Detection");
  desc = "
  Overview: This script detects the installed version of Rhino Software
  Serv-U and sets the result in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of Rhino Software Serv-U");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes", "ssh_detect.nasl");
  script_require_ports("Services/ftp", 21, "Services/ssh", 22);
  exit(0);
}


include("ftp_func.inc");

function ServuGetVer(su_port, pat)
{
  if(get_port_state(su_port))
  {
    banner = get_ftp_banner(port:su_port);
    if("Serv-U" >< banner)
    {
      ver = eregmatch(pattern:pat, string:banner);
      return ver;
    }
    else
      return NULL;
  }
}


servuPort = get_kb_item("Services/ssh");

if(!servuPort){
  servuPort = 22;
}

pattern1 = "Serv-U_([0-9.]+)";
pattern2 = "Serv-U FTP Server v([0-9.]+)";

servuVer = ServuGetVer(su_port:servuPort, pat:pattern1);
if(!isnull(servuVer[1])){
  set_kb_item(name:"Serv-U/FTP/Ver", value:servuVer[1]);
}
else
{
  servuPort = get_kb_item("Services/ftp");
  if(!servuPort){
    servuPort = 21;
  }

  if(get_port_state(servuPort)) {

    soc = open_sock_tcp(servuPort);

    if (soc) {
    
      banner = ftp_recv_line(socket:soc);
    
      if("220 Serv-U" >< banner) {

         req = string("CSID\r\n");
         send(socket:soc, data:req);
         buf = ftp_recv_line(socket:soc);
    
         if(!isnull(buf)) {
            if("200 Name=Serv-U" >< buf) {
               version = eregmatch(string: buf, pattern:"Version=([^;]+);");
            }
         }
    
      }

      ftp_close(socket:soc);
    }
  }

  if(!isnull(version[1])) {
  
    set_kb_item(name:"Serv-U/FTP/Ver", value:version[1]);
    set_kb_item(name:string("ftp/", servuPort, "/Serv-U"), value:version[1]);
    security_note(data:"Rhino Software Serv-U FTP version " + version[1] + 
                           " was detected on the host");

  } else {

      servuVer = ServuGetVer(su_port:servuPort, pat:pattern2);
      if(!isnull(servuVer[1]))
      { # This check is inaccurate for 9.x versions (Don't know about versions <9)
        # but better then nothing. Version 9 Banner is "220 Serv-U FTP Server v9.0
        # ready..." while real version is 9.0.0.5. 
        set_kb_item(name:"Serv-U/FTP/Ver", value:servuVer[1]);
        security_note(data:"Rhino Software Serv-U FTP version " + servuVer[1] + 
                           " was detected on the host");
      }
    }
}
