###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_php_detect.nasl 311 2008-10-07 15:15:24Z oct $
#
# PHP Version Detection
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800109);
  script_version("Revision: 1.1");
  script_tag(name:"risk_factor", value:"None");
  script_name("PHP Version Detection");
  desc = "
  Overview : This script finds the installed PHP Version and saves the
  version in KB.

  Risk factor : None";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_summary("Set Version of PHP in KB");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

phpPort = get_http_port(default:80);
if(!get_port_state(phpPort)){
  exit(0);
}

banner = get_http_banner(port:phpPort);
if("PHP" >!< banner){
  exit(0);
}

# PHP can be installed as a stand-alone package, local checks
# have to be separately written.

phpInfo = egrep(pattern:"Server.*PHP.*", string:banner);
if(!phpInfo){
  phpInfo = egrep(pattern:"X.Powered.By.*PHP.*", string:banner);
}

phpVer = ereg_replace(pattern:".*PHP/([.0-9]*).*", string:phpInfo, replace:"\1");
if(phpVer)
{
  set_kb_item(name:"www/" + phpPort + "/PHP", value:phpVer);
  security_note(data:"PHP version " + phpVer + " was detected on the host");
}
