###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_openoffice_mult_vuln_oct09.nasl 5198 2009-10-08 14:22:17Z oct $
#
# OpenOffice.org Multiple Vulnerabilities - Oct09 (Win)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801114);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3569", "CVE-2009-3570", "CVE-2009-3571");
  script_bugtraq_id(36285);
  script_name("OpenOffice.org Multiple Vulnerabilities - Oct09 (Win)");
  desc = "
  Overview: The host has OpenOffice.org installed and is prone to multiple
  vulnerabilities.

  Vulnerability Insight:
  OpenOffice is prone to multiple unspecified remote security vulnerabilities,
  including a stack-based overflow issue and two other unspecified issues.

  Impact:
  Attackers can exploit these issues to execute code within the context of
  the affected application and can deny the service.

  Impact Level: Application

  Affected Software/OS:
  OpenOffice.org version 3.1.1 and prior on Windows.

  Fix: No solution or patch is available as on 08th October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.openoffice.org/

  References:
  http://intevydis.com/vd-list.shtml
  http://securitytracker.com/alerts/2009/Sep/1022832.html

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_summary("Check for the version of OpenOffice.org");
  script_category(ACT_GATHER_INFO);
  script_family("Buffer overflow");
  script_dependencies("secpod_openoffice_detect_win.nasl");
  script_require_keys("OpenOffice/Win/Ver");
  exit(0);
}


include("version_func.inc");

openVer = get_kb_item("OpenOffice/Win/Ver");
if(!openVer){
  exit(0);
}

# Check for OpenOffice version 3.1.1 => (3.1.9420)
if(version_is_less_equal(version:openVer, test_version:"3.1.9420")){
  security_hole(0);
}
