###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_html_help_ws_bof_vuln.nasl 860 2009-01-16 15:06:24Z Jan $ 
# 
# Microsoft HTML Help Workshop buffer overflow vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800505);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0133");
  script_bugtraq_id(33189);
  script_name("Microsoft HTML Help Workshop buffer overflow vulnerability");
  desc = "

  Overview: The host is running Microsoft HTML Help Workshop which is 
  prone to buffer overflow vulnerability.

  Vulnerability Insight:
  A flaw is due to the way application handle a malformed HTML help workshop
  project.
  
  Impact: Successful remote exploitation could context-dependent attackers
  to execute arbitrary code via a .hhp file with a long index file field.

  Impact Level: System.

  Affected Software/OS:
  Microsoft HTML Help Workshop 4.74 and prior on Windows.

  Fix: No solution or patch is available as on 19th January, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://office.microsoft.com/en-us/orkXP/HA011362801033.aspx

  References:
  http://www.milw0rm.com/exploits/7727
  http://en.securitylab.ru/nvd/366501.php
  http://www.security-database.com/detail.php?alert=CVE-2009-0133

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Microsoft HTML Help Workshop");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Windows");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

wsPath = registry_get_sz(item:"Path",
         key:"SOFTWARE\Microsoft\Windows\CurrentVersion\App Paths\hhw.exe");
if(!wsPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:wsPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:wsPath + "\hhw.exe");

wsVer = GetVer(file:file, share:share);
if(!wsVer){
  exit(0);
}

# Grep for version <= 4.74 series.
if(version_is_less_equal(version:wsVer, test_version:"4.74.8702.0")){
  security_hole(0);
}
