###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_httpdx_web_server_bof_vuln.nasl 5353 2009-10-23 10:40:24Z oct $
#
# httpdx Web Server 'h_handlepeer()' Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800962);
  script_version("$Revision: 1.0$");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3711");
  script_name("httpdx Web Server 'h_handlepeer()' Buffer Overflow Vulnerability");
  desc = "
  Overview: The host is running httpdx Web Server and is prone to Buffer
  Overflow vulnerability.

  Vulnerability Insight:
  A boundary error occurs in 'h_handlepeer()' in 'http.cpp' while processing
  overly long HTTP requests leading to buffer overflow.

  Impact:
  Remote attackers can exploit this issue to execute arbitrary code or crash
  the server via a specially crafted request.

  Impact Level: Application

  Affected Software/OS:
  httpdx Web Server version 1.4.3 and prior on windows.

  Fix: Upgrade to httpdx Server version 1.4.4 or later
  http://sourceforge.net/projects/httpdx/

  References:
  http://secunia.com/advisories/36991
  http://www.vupen.com/english/advisories/2009/2874
  http://www.securityfocus.com/archive/1/archive/1/507042/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of httpdx Web Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_httpdx_server_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

httpdxPort = get_http_port(default:80);
if(!httpdxPort){
  exit(0);
}

httpdxVer = get_kb_item("httpdx/" + httpdxPort + "/Ver");
if(!isnull(httpdxVer))
{
  # Check for versions prior to 1.4.4
  if(version_is_less(version:httpdxVer, test_version:"1.4.4")){
    security_hole(httpdxPort);
  }
}
