###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for Apache with PHP HPSBUX01090
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835139);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "HPSBUX", value: "01090");
  script_cve_id("CAN-2004-0747", "CAN-2004-0748", "CAN-2004-0751", "CAN-2004-0786", "CAN-2004-0809", "CAN-2004-0811");
  script_name( "HP-UX Update for Apache with PHP HPSBUX01090");
  desc = "

  Vulnerability Insight:
  Several potential security vulnerabilities have been identified inApache Web 
  Server and PHP running on HP-UX where a remoteuser may be able to cause a 
  Denial of Service (DoS), obtainlocal elevation of privileges or gain 
  unauthorized access torestricted resources.<br 

  Impact:
  Remote denial of service
  local increase in privilege

  Affected Software/OS:
  Apache with PHP on
  HP-UX B.11.00, B.11.11, B.11.22, and B.11.23 running the currently supported 
  versions of hpuxwsAPACHE HP-UX 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00901851-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Apache with PHP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"A.2.0.52.00", rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"A.2.0.52.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"B.2.0.52.00", rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"hpuxwsAPACHE", revision:"B.2.0.52.00", rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
