###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_google_sketchup_mult_vuln_jan10_win.nasl 6861 2010-01-19 11:20:26Z jan $
#
# Google SketchUp Multiple Vulnerabilities (Windows)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800435);
  script_version("$Revision: 8150 $: 1.0");
  script_tag(name:"cvss_base", value:"9.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2010-0316", "CVE-2010-0280");
  script_bugtraq_id(37708);
  script_name("Google SketchUp Multiple Vulnerabilities (Windows)");
  desc = "
  Overview: This host is installed with Google SketchUp and is prone to
  to multiple vulnerabilities.

  Vulnerability Insight:
  The flaws exists due to:
   - An array indexing error when processing '3DS' files which can be exploited
     to corrupt memory.
   - An integer overflow error when processing 'SKP' files which can be
     exploited to corrupt heap memory.

  Impact:
  Successful exploitation will let the attacker to execute arbitrary code and
  can cause Denial of Service.

  Impact Level: Application

  Affected Software/OS:
  Google SketchUp version 7.0 before 7.1 M2(7.1.6860.0)

  Fix: Upgrade to Google SketchUp version 7.1 M2.
  For updates refer, http://sketchup.google.com/download/index2.html

  References:
  http://secunia.com/advisories/38185
  http://secunia.com/advisories/38187/3/
  http://www.vupen.com/english/advisories/2010/0133
  http://www.coresecurity.com/content/google-sketchup-vulnerability

  CVSS Score:
    CVSS Base Score      : 9.0 (AV:N/AC:L/Au:NR/C:C/I:P/A:P)
    CVSS Temporal Score  : 7.6
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the version of Google SketchUp");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("gb_google_sketchup_detect_win.nasl");
  script_require_keys("Google/SketchUp/Win/Ver");
  exit(0);
}


include("version_func.inc");

gsVer = get_kb_item("Google/SketchUp/Win/Ver");
if(!gsVer){
  exit(0);
}

# Check for Google SketchUp 7.1 m2 (7.1.6860.0)
if(version_in_range(version:gsVer, test_version:"7.0", test_version2:"7.1.6859")){
  security_hole(0);
}
