###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_firefox_detect_lin.nasl 302 2008-10-13 15:57:11Z oct $
#
# Mozilla Firefox Version Detection (Linux)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# Modified to Detect All Installed Version
#  - By Sharath S <sharaths@secpod.com> on 2009-09-04 #4411
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(800017);
  script_version("$Revision: 1.1 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Mozilla Firefox Version Detection (Linux)");
  desc = "
  Overview : This script finds the Mozilla Firefox installed version on Linux
  and save the version in KB.

  Risk factor : None";

  script_description(desc);
  script_family("Service detection");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_summary("Set file version of Mozilla Firefox in KB");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

fox_sock = ssh_login_or_reuse_connection();
if(!fox_sock)
{
  exit(0);
}

foxName = find_file(file_name:"firefox", file_path:"/", useregex:TRUE,
                    regexpar:"$", sock:fox_sock);

foreach binary_foxName (foxName)
{
  binary_name = chomp(binary_foxName);
  foxVer = get_bin_version(full_prog_name:binary_name, sock:fox_sock,
                           version_argv:"-v", ver_pattern:"Mozilla Firefox " +
                           "([0-9]\.[0-9.]+([a-z0-9]+)?)");
  if(!isnull(foxVer[1]))
  {
    set_kb_item(name:"Firefox/Linux/Ver", value:foxVer[1]);
    security_note(data:"Firefox Browser version " + foxVer[1] + " running at" + 
                       " location " + binary_foxName +  " was detected on the host");
  }
}
ssh_close_connection();
