###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for net-snmp FEDORA-2008-9362
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860684);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "FEDORA", value: "2008-9362");
  script_cve_id("CVE-2008-4309", "CVE-2008-2292", "CVE-2008-0960");
  script_name( "Fedora Update for net-snmp FEDORA-2008-9362");
  desc = "

  Vulnerability Insight:
  SNMP (Simple Network Management Protocol) is a protocol used for
  network management. The NET-SNMP project includes various SNMP tools:
  an extensible agent, an SNMP library, tools for requesting or setting
  information from SNMP agents, tools for generating and handling SNMP
  traps, a version of the netstat command which uses SNMP, and a Tk/Perl
  mib browser. This package contains the snmpd and snmptrapd daemons,
  documentation, etc.
  
  You will probably also want to install the net-snmp-utils package,
  which contains NET-SNMP utilities.
  
  Building option:
  	--without tcp_wrappers : disable tcp_wrappers support


  Affected Software/OS:
  net-snmp on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-November/msg00021.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of net-snmp");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"net-snmp", rpm:"net-snmp~5.4.1~8.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}