###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for git FEDORA-2008-9080
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860619);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-9080");
  script_cve_id("CVE-2008-3546");
  script_name( "Fedora Update for git FEDORA-2008-9080");
  desc = "

  Vulnerability Insight:
  Git is a fast, scalable, distributed revision control system with an
  unusually rich command set that provides both high-level operations
  and full access to internals.
  
  The git rpm installs the core tools with minimal dependencies.  To
  install all git packages, including tools for integrating with other
  SCMs, install the git-all meta-package.


  Affected Software/OS:
  git on Fedora 9

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-October/msg00729.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of git");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC9")
{

  if(isrpmvuln(pkg:"git", rpm:"git~1.5.6.5~1.fc9", rls:"FC9"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}