###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for Perlbal FEDORA-2008-2788
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860248);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-2788");
  script_name( "Fedora Update for Perlbal FEDORA-2008-2788");
  desc = "

  Vulnerability Insight:
  Perlbal is a single-threaded event-based server supporting HTTP load
  balancing, web serving, and a mix of the two. Perlbal can act as either a web
  server or a reverse proxy.
  
  One of the defining things about Perlbal is that almost everything can be
  configured or reconfigured on the fly without needing to restart the software.
  A basic configuration file containing a management port enables you to easily
  perform operations on a running instance of Perlbal.
  
  Perlbal can also be extended by means of per-service (and global) plugins that
  can override many parts of request handling and behavior.


  Affected Software/OS:
  Perlbal on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-March/msg00672.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Perlbal");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"Perlbal", rpm:"Perlbal~1.70~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}