###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for roundcubemail FEDORA-2008-11581
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860235);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"7.8");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2008-11581");
  script_cve_id("CVE-2008-5620");
  script_name( "Fedora Update for roundcubemail FEDORA-2008-11581");
  desc = "

  Vulnerability Insight:
  RoundCube Webmail is a browser-based multilingual IMAP client
  with an application-like user interface. It provides full
  functionality you expect from an e-mail client, including MIME
  support, address book, folder manipulation, message searching
  and spell checking. RoundCube Webmail is written in PHP and
  requires the MySQL database or the PostgreSQL database. The user
  interface is fully skinnable using XHTML and CSS 2.


  Affected Software/OS:
  roundcubemail on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-December/msg01021.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of roundcubemail");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"roundcubemail", rpm:"roundcubemail~0.2~5.beta.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}