###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for libX11 FEDORA-2007-426
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861350);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-426");
  script_name( "Fedora Update for libX11 FEDORA-2007-426");
  desc = "

  Vulnerability Insight:
  X.Org X11 libX11 runtime library
  
  ---------------------------------------------------------------------
  
  * Fri Apr  6 2007 Adam Jackson &lt;ajax redhat com&gt; 1.0.3-7
  - libX11-cve-2007-1667.patch: Fix CVE 2007-1667


  Affected Software/OS:
  libX11 on Fedora Core 6

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-April/msg00029.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of libX11");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC6")
{

  if(isrpmvuln(pkg:"libX11", rpm:"libX11~1.0.3~7.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/debug/libX11-debuginfo", rpm:"x86_64/debug/libX11-debuginfo~1.0.3~7.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/libX11", rpm:"x86_64/libX11~1.0.3~7.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x86_64/libX11-devel", rpm:"x86_64/libX11-devel~1.0.3~7.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/debug/libX11-debuginfo", rpm:"i386/debug/libX11-debuginfo~1.0.3~7.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/libX11-devel", rpm:"i386/libX11-devel~1.0.3~7.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"i386/libX11", rpm:"i386/libX11~1.0.3~7.fc6", rls:"FC6"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}