###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for hsqldb FEDORA-2007-4119
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860913);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "FEDORA", value: "2007-4119");
  script_cve_id("CVE-2007-4576");
  script_name( "Fedora Update for hsqldb FEDORA-2007-4119");
  desc = "

  Vulnerability Insight:
  HSQLdb is a relational database engine written in JavaTM , with a JDBC
  driver, supporting a subset of ANSI-92 SQL. It offers a small (about
  100k), fast database engine which offers both in memory and disk based
  tables. Embedded and server modes are available. Additionally, it
  includes tools such as a minimal web server, in-memory query and
  management tools (can be run as applets or servlets, too) and a number
  of demonstration examples.
  Downloaded code should be regarded as being of production quality. The
  product is currently being used as a database and persistence engine in
  many Open Source Software projects and even in commercial projects and
  products! In it's current version it is extremely stable and reliable.
  It is best known for its small size, ability to execute completely in
  memory and its speed. Yet it is a completely functional relational
  database management system that is completely free under the Modified
  BSD License. Yes, that's right, completely free of cost or restrictions!


  Affected Software/OS:
  hsqldb on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-January/msg00753.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of hsqldb");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"hsqldb", rpm:"hsqldb~1.8.0.8~1jpp.5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hsqldb", rpm:"hsqldb~1.8.0.8~1jpp.5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hsqldb-manual", rpm:"hsqldb-manual~1.8.0.8~1jpp.5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hsqldb-demo", rpm:"hsqldb-demo~1.8.0.8~1jpp.5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hsqldb-debuginfo", rpm:"hsqldb-debuginfo~1.8.0.8~1jpp.5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hsqldb-javadoc", rpm:"hsqldb-javadoc~1.8.0.8~1jpp.5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hsqldb-javadoc", rpm:"hsqldb-javadoc~1.8.0.8~1jpp.5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hsqldb-demo", rpm:"hsqldb-demo~1.8.0.8~1jpp.5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hsqldb-debuginfo", rpm:"hsqldb-debuginfo~1.8.0.8~1jpp.5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hsqldb", rpm:"hsqldb~1.8.0.8~1jpp.5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"hsqldb-manual", rpm:"hsqldb-manual~1.8.0.8~1jpp.5.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}