###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_energizer_duo_usb_unauth_access_vuln.nasl 7681 2010-03-17 13:09:24Z mar $
#
# Energizer DUO USB Battery Charger Software Backdoor
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800491);
  script_version("$Revision:1.0$");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2010-0103");
  script_bugtraq_id(38571);
  script_name("Energizer DUO USB Battery Charger Software Backdoor");
  desc = "
  Overview: This host is installed with Energizer DUO USB Battery Charger Software
  which contains a backdoor.

  Vulnerability Insight:
  As part of the installation process of 'USB charger software package', a
  file 'Arucer.dll' is created and added to the registry run key and this file
  is the Trojan. Trojan listens for commands from anyone who connects and can
  perform various actions, such as:
   - Download a file
   - Execute a file
   - Send a directory/files listing to the remote attacker

  Impact:
  Successful exploitation let attackers to remotely control a system, including
  the ability to list directories. The backdoor operates with the privileges of
  the logged-on user.

  Impact Level: System

  Affected Software/OS:
  Energizer DUO USB Battery Charger Software

  Fix: No solution/patch is available as on 17th March, 2010. Information
  regarding this issue will update once the solution details are available.
  For updates refer, http://www.energizer.com/usbcharger/

  Workaround:
  Apply workaround,
  http://www.kb.cert.org/vuls/id/154421

  References:
  http://www.kb.cert.org/vuls/id/154421
  http://www.threatexpert.com/report.aspx?md5=3f4f10b927677e45a495d0cdd4390aaf
  http://www.symantec.com/connect/blogs/trojan-found-usb-battery-charger-software
  http://www.marketwatch.com/story/energizer-announces-duo-charger-and-usb-charger-software-problem-2010-03-05

  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score  : 7.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for Energizer DUO USB Battery Charger Software and 'Arucer.dll'");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(registry_key_exists(key:"SOFTWARE\Microsoft\Windows\CurrentVersion\Run"))
{
  dllPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                           item:"Install Path");
  if(!dllPath){
    exit(0);
  }

  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                    string:dllPath + "\Arucer.dll");
   dllVer = GetVer(file:file, share:share);
   if(!isnull(dllVer)){
    security_hole(0);
  }
}
