###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_document_manager_detect.nasl 7274 2010-02-18 16:25:36Z feb $
#
# Document Manager Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800477);
  script_version("Revision$: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("Document Manager Version Detection");
  desc = "
  Overview: This script finds the running Document Manager version and saves
  the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the version of Document Manager in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("http_keepalive.inc");

dmPort = get_http_port(default:80);
if(!dmPort){
  exit(0);
}

foreach path (make_list("/", "/dmanager", cgi_dirs()))
{
  sndReq = http_get(item:string(path, "/php/login.php"), port:dmPort);
  rcvRes = http_keepalive_send_recv(port:dmPort, data:sndReq);

  if("Document Manager" >< rcvRes || "Porte Documents" >< rcvRes)
  {
    dmVer = eregmatch(pattern:"version ([0-9.]+)", string:rcvRes);
    if(dmVer[1] != NULL){
      dmVer = dmVer[1];
    }
    else
    {
      sndReq = http_get(item:string(path, "/php/version"), port:dmPort);
      rcvRes = http_keepalive_send_recv(port:dmPort, data:sndReq, bodyonly:1);
      if(!isnull(rcvRes))
      {
        dmVer = eregmatch(pattern:"([0-9.]+)", string:rcvRes);
        if(dmVer[1] != NULL){
          dmVer = dmVer[1];
        }
      }
    }

    set_kb_item(name:"www/" + dmPort + "/DocManager",
                value:dmVer + " under " + path);
    security_note(data:"Document Manager version " + dmVer + " running at" + 
                       " location " + path + " was detected on the host");
  }
}
