###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_alleycode_html_editor_bof_vuln.nasl 5352 2009-10-23 19:29:29Z oct $
#
# Alleycode HTML Editor Buffer Overflow Vulnerabilities
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801127);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3708", "CVE-2009-3709");
  script_name("Alleycode HTML Editor Buffer Overflow Vulnerabilities");
  desc = "
  Overview: This host is installed with Alleycode HTML Editor and is prone to
  Buffer Overflow vulnerabilities.

  Vulnerability Insight:
  Multiple boundary error exists in the Meta Content Optimizer when displaying
  the content of 'TITLE' or 'META' HTML tags. This can be exploited to cause a
  stack-based buffer overflow via an HTML file defining an overly long 'TITLE'
  tag, 'description' or 'keywords' 'META' tag.

  Impact:
  Successful exploitation will let the attackers to execute arbitrary code or
  compromise a user's system.

  Impact Level: System/Application

  Affected Software/OS:
  Alleycode HTML Editor version 2.21 and prior

  Fix: No solution or patch is available as on 23rd October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.alleycode.com/

  References:
  http://osvdb.org/58649
  http://secunia.com/advisories/36940
  http://packetstormsecurity.org/0910-exploits/alleycode-overflow.txt

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Alleycode HTML Editor");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_alleycode_html_editor_detect.nasl");
  script_require_keys("Alleycode-HTML-Editor/Ver");
  exit(0);
}


include("version_func.inc");

aheVer = get_kb_item("Alleycode-HTML-Editor/Ver");
if(!aheVer){
  exit(0);
}

# Check for Alleycode HTML Editor version <= 2.21 (2.2.1)
if(version_is_less_equal(version:aheVer, test_version:"2.2.1")){
  security_hole(0);
}
