###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for autofs5 CESA-2007:1177 centos4 x86_64
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880335);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.9");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "CESA", value: "2007:1177");
  script_cve_id("CVE-2007-6285", "CVE-2007-5964");
  script_name( "CentOS Update for autofs5 CESA-2007:1177 centos4 x86_64");
  desc = "

  Vulnerability Insight:
  The autofs utility controls the operation of the automount daemon, which
  automatically mounts file systems when you use them, and unmounts them when
  you are not using them. This can include network file systems and CD-ROMs.
  The autofs5 packages were made available as a technology preview in Red Hat
  Enterprise Linux 4.6.
  
  There was a security issue with the default configuration of autofs version
  5, whereby the entry for the &quot;-hosts&quot; map did not specify the &quot;nodev&quot; mount
  option. A local user with control of a remote NFS server could create
  special device files on the remote file system, that if mounted using the
  default &quot;-hosts&quot; map, could allow the user to access important system
  devices. (CVE-2007-6285)
  
  This issue is similar to CVE-2007-5964, which fixed a missing &quot;nosuid&quot;
  mount option in autofs. Both the &quot;nodev&quot; and &quot;nosuid&quot; options should be
  enabled to prevent a possible compromise of machine integrity.
  
  Due to the fact that autofs always mounted &quot;-hosts&quot; map entries &quot;dev&quot; by
  default, autofs has now been altered to always use the &quot;nodev&quot; option when
  mounting from the default &quot;-hosts&quot; map. The &quot;dev&quot; option must be explicitly
  given in the master map entry to revert to the old behavior. This change
  affects only the &quot;-hosts&quot; map which corresponds to the &quot;/net&quot; entry in the
  default configuration.
  
  All autofs5 users are advised to upgrade to these updated packages, which
  resolve this issue.
  
  Red Hat would like to thank Tim Baum for reporting this issue.


  Affected Software/OS:
  autofs5 on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2007-December/014545.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of autofs5");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CentOS4")
{

  if(isrpmvuln(pkg:"autofs5", rpm:"autofs5~5.0.1~0.rc2.55.el4_6.2", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
