#
#ADV FreeBSD-SA-04:03.jail.asc
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
#
                                                                                
if(description)
{
 script_id(52645);
 script_bugtraq_id(9762);
 script_cve_id("CVE-2004-0126");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Security Advisory (FreeBSD-SA-04:03.jail.asc)";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory FreeBSD-SA-04:03.jail.asc

The jail(2) system call allows a system administrator to lock up a
process and all its descendants inside a closed environment with very
limited ability to affect the system outside that environment, even
for processes with superuser privileges.  It is an extension of, but
far more stringent than, the traditional Unix chroot(2) system call.

The jail_attach(2) system call, which was introduced in FreeBSD 5
before 5.1-RELEASE, allows a non-jailed process to permanently move
into an existing jail.

A programming error has been found in the jail_attach(2) system call
which affects the way that system call verifies the privilege
level of the calling process.  Instead of failing immediately if the
calling process was already jailed, the jail_attach(2) system call
would fail only after changing the calling process's root directory.

Solution:
Upgrade your system to the appropriate stable release
or security branch dated after the correction date

https://secure1.securityspace.com/smysecure/catid.html?in=FreeBSD-SA-04:03.jail.asc
Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Security Advisory (FreeBSD-SA-04:03.jail.asc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdpatchlevel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
if(patchlevelcmp(rel:"5.1", patchlevel:"14")<0) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
