#
#VID 75f2382e-b586-11dd-95f9-00e0815b8da8
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 75f2382e-b586-11dd-95f9-00e0815b8da8
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61919);
 script_cve_id("CVE-2008-5110");
 script_version ("$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: syslog-ng2";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: syslog-ng2

CVE-2008-5110
syslog-ng does not call chdir when it calls chroot, which might allow
attackers to escape the intended jail.  NOTE: this is only a
vulnerability when a separate vulnerability is present.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=505791
http://www.openwall.com/lists/oss-security/2008/11/17/3
http://www.vuxml.org/freebsd/75f2382e-b586-11dd-95f9-00e0815b8da8.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: syslog-ng2";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"syslog-ng2");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.9_2")<0) {
    security_note(0, data:"Package syslog-ng2 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
