#
#VID a711de5c-05fa-11d9-a9b2-00061bc2ad93
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52392);
 script_cve_id("CVE-2004-0807", "CVE-2004-0808");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: samba3";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: samba3

CVE-2004-0807
Samba 3.0.6 and earlier allows remote attackers to cause a denial of
service (infinite loop and memory exhaustion) via certain malformed
requests that cause new processes to be spawned and enter an infinite
loop.

CVE-2004-0808
The process_logon_packet function in the nmbd server for Samba 3.0.6
and earlier, when domain logons are enabled, allows remote attackers
to cause a denial of service via a SAM_UAS_CHANGE request with a
length value that is larger than the number of structures that are
provided.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.idefense.com/application/poi/display?id=139&type=vulnerabilities
http://www.vuxml.org/freebsd/a711de5c-05fa-11d9-a9b2-00061bc2ad93.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: samba3";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"samba3");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.7,1")<0) {
    security_note(0, data:"Package samba3 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
