#
#VID 85b0bbc8-a7a5-11dd-8283-001c2514716c
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 85b0bbc8-a7a5-11dd-8283-001c2514716c
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61882);
 script_cve_id("CVE-2008-4775");
 script_bugtraq_id(31928);
 script_version ("$");
 script_tag(name:"cvss_base", value:"2.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: phpMyAdmin";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   phpMyAdmin
   phpMyAdmin211

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.phpmyadmin.net/home_page/security.php?issue=PMASA-2008-9
http://www.vuxml.org/freebsd/85b0bbc8-a7a5-11dd-8283-001c2514716c.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: phpMyAdmin";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"phpMyAdmin");
if(!isnull(bver) && revcomp(a:bver, b:"3.0")>0 && revcomp(a:bver, b:"3.0.1.1")<0) {
    security_note(0, data:"Package phpMyAdmin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"2.11.9.3")<0) {
    security_note(0, data:"Package phpMyAdmin version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"phpMyAdmin211");
if(!isnull(bver) && revcomp(a:bver, b:"2.11.9.3")<0) {
    security_note(0, data:"Package phpMyAdmin211 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
