#
#VID 58a3c266-db01-11dd-ae30-001cc0377035
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 58a3c266-db01-11dd-ae30-001cc0377035
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63105);
 script_cve_id("CVE-2008-5498");
 script_bugtraq_id(33002);
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: php5-gd";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: php5-gd

CVE-2008-5498
Array index error in the imageRotate function in PHP 5.2.8 and earlier
allows context-dependent attackers to read the contents of arbitrary
memory locations via a crafted value of the third argument (aka the
bgd_color or clrBack argument) for an indexed image.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.securiteam.com/unixfocus/6G00Y0ANFU.html
http://www.vuxml.org/freebsd/58a3c266-db01-11dd-ae30-001cc0377035.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: php5-gd";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"php5-gd");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package php5-gd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
