#
#VID 4e8344a3-ca52-11de-8ee8-00215c6a37bb
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 4e8344a3-ca52-11de-8ee8-00215c6a37bb
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66153);
 script_cve_id("CVE-2009-3546");
 script_bugtraq_id(36712);
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("FreeBSD Ports: gd");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   gd
   php5-gd
   php4-gd

CVE-2009-3546
The _gdGetColors function in gd_gd.c in PHP 5.2.11 and 5.3.0, and the
GD Graphics Library 2.x, does not properly verify a certain
colorsTotal structure member, which might allow remote attackers to
conduct buffer overflow or buffer over-read attacks via a crafted GD
file, a different vulnerability than CVE-2009-3293.  NOTE: some of
these details are obtained from third party information.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/37069
http://secunia.com/advisories/37080
http://www.vuxml.org/freebsd/4e8344a3-ca52-11de-8ee8-00215c6a37bb.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: gd");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gd");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.35_2,1")<0) {
    security_note(0, data:"Package gd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php5-gd");
if(!isnull(bver) && revcomp(a:bver, b:"5.2.11_2")<0) {
    security_note(0, data:"Package php5-gd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"php4-gd");
if(!isnull(bver) && revcomp(a:bver, b:"0")>0) {
    security_note(0, data:"Package php4-gd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
