#
#VID 6e099997-25d8-11dc-878b-000c29c5647f
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58836);
 script_cve_id("CVE-2007-3472", "CVE-2007-3473", "CVE-2007-3474", "CVE-2007-3475", "CVE-2007-3476", "CVE-2007-3477", "CVE-2007-3478");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: gd";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: gd

=====

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.libgd.org/ReleaseNote020035
http://www.frsirt.com/english/advisories/2007/2336
http://bugs.libgd.org/?do=details&task_id=89
http://bugs.libgd.org/?do=details&task_id=94
http://bugs.libgd.org/?do=details&task_id=70
http://bugs.libgd.org/?do=details&task_id=87
http://bugs.libgd.org/?do=details&task_id=92
http://bugs.libgd.org/?do=details&task_id=74
http://bugs.libgd.org/?do=details&task_id=48
http://bugs.php.net/bug.php?id=40578
http://www.vuxml.org/freebsd/6e099997-25d8-11dc-878b-000c29c5647f.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: gd";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"gd");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.35,1")<0) {
    security_note(0, data:"Package gd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
