#
#VID 01c57d20-ea26-11de-bd39-00248c9b4be7
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 01c57d20-ea26-11de-bd39-00248c9b4be7
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66613);
 script_cve_id("CVE-2009-3388", "CVE-2009-3389", "CVE-2009-3979", "CVE-2009-3980", "CVE-2009-3981", "CVE-2009-3982", "CVE-2009-3983", "CVE-2009-3984", "CVE-2009-3985", "CVE-2009-3986");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("FreeBSD Ports: firefox");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   firefox
   linux-firefox
   seamonkey
   linux-seamonkey

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.mozilla.org/security/announce/2009/mfsa2009-71.html
http://www.mozilla.org/security/announce/2009/mfsa2009-70.html
http://www.mozilla.org/security/announce/2009/mfsa2009-69.html
http://www.mozilla.org/security/announce/2009/mfsa2009-68.html
http://www.mozilla.org/security/announce/2009/mfsa2009-67.html
http://www.mozilla.org/security/announce/2009/mfsa2009-66.html
http://www.mozilla.org/security/announce/2009/mfsa2009-65.html
http://www.vuxml.org/freebsd/01c57d20-ea26-11de-bd39-00248c9b4be7.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: firefox");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"firefox");
if(!isnull(bver) && revcomp(a:bver, b:"3.5.*,1")>0 && revcomp(a:bver, b:"3.5.6,1")<0) {
    security_note(0, data:"Package firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"3.*,1")>0 && revcomp(a:bver, b:"3.0.16,1")<0) {
    security_note(0, data:"Package firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-firefox");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.16,1")<0) {
    security_note(0, data:"Package linux-firefox version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"seamonkey");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.1")<0) {
    security_note(0, data:"Package seamonkey version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"linux-seamonkey");
if(!isnull(bver) && revcomp(a:bver, b:"2.0.1")<0) {
    security_note(0, data:"Package linux-seamonkey version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
