#
#VID 21c223f2-d596-11da-8098-00123ffe8333
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56652);
 script_cve_id("CVE-2006-1932", "CVE-2006-1933", "CVE-2006-1934", "CVE-2006-1935", "CVE-2006-1936", "CVE-2006-1937", "CVE-2006-1938", "CVE-2006-1939", "CVE-2006-1940");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: ethereal, ethereal-lite, tethereal, tethereal-lite";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   ethereal
   ethereal-lite
   tethereal
   tethereal-lite

CVE-2006-1932
Off-by-one error in the OID printing routine in Ethereal 0.10.x up to
0.10.14 has unknown impact and remote attack vectors.

CVE-2006-1933
Multiple unspecified vulnerabilities in Ethereal 0.10.x up to 0.10.14
allow remote attackers to cause a denial of service (large or infinite
loops) viarafted packets to the (1) UMA and (2) BER dissectors.

CVE-2006-1934
Multiple buffer overflows in Ethereal 0.10.x up to 0.10.14 allow
remote attackers to cause a denial of service (crash) and possibly
execute arbitrary code via the (1) ALCAP dissector, (2) Network
Instruments file code, or (3) NetXray/Windows Sniffer file code.

CVE-2006-1935
Buffer overflow in Ethereal 0.9.15 up to 0.10.14 allows remote
attackers to cause a denial of service (crash) and possibly execute
arbitrary code via the COPS dissector.

CVE-2006-1936
Buffer overflow in Ethereal 0.8.5 up to 0.10.14 allows remote
attackers to execute arbitrary code via the telnet dissector.

CVE-2006-1937
Multiple unspecified vulnerabilities in Ethereal 0.10.x up to 0.10.14
allow remote attackers to cause a denial of service (crash from null
dereference) via the (1) H.248, (2) X.509if, (3) SRVLOC, (4) H.245,
(5) AIM, and (6) general packet dissectors; and (7) the statistics
counter.

CVE-2006-1938
Multiple unspecified vulnerabilities in Ethereal 0.8.x up to 0.10.14
allow remote attackers to cause a denial of service (crash from null
dereference) via the (1) Sniffer capture or (2) SMB PIPE dissector.

CVE-2006-1939
Multiple unspecified vulnerabilities in Ethereal 0.9.x up to 0.10.14
allow remote attackers to cause a denial of service (crash from null
dereference) via (1) an invalid display filter, or the (2) GSM SMS,
(3) ASN.1-based, (4) DCERPC NT, (5) PER, (6) RPC, (7) DCERPC, and (8)
ASN.1 dissectors.

CVE-2006-1940
Unspecified vulnerability in Ethereal 0.10.4 up to 0.10.14 allows
remote attackers to cause a denial of service (abort) via the SNDCP
dissector.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://www.ethereal.com/appnotes/enpa-sa-00023.html
http://secunia.com/advisories/19769/
http://www.vuxml.org/freebsd/21c223f2-d596-11da-8098-00123ffe8333.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: ethereal, ethereal-lite, tethereal, tethereal-lite";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ethereal");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.5")>=0 && revcomp(a:bver, b:"0.99.0")<0) {
    security_note(0, data:"Package ethereal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ethereal-lite");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.5")>=0 && revcomp(a:bver, b:"0.99.0")<0) {
    security_note(0, data:"Package ethereal-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"tethereal");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.5")>=0 && revcomp(a:bver, b:"0.99.0")<0) {
    security_note(0, data:"Package tethereal version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"tethereal-lite");
if(!isnull(bver) && revcomp(a:bver, b:"0.8.5")>=0 && revcomp(a:bver, b:"0.99.0")<0) {
    security_note(0, data:"Package tethereal-lite version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
