# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8997 (xemacs)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64815);
 script_cve_id("CVE-2009-2688");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 10 FEDORA-2009-8997 (xemacs)");

 desc = "The remote host is missing an update to xemacs
announced via advisory FEDORA-2009-8997.

Update Information:

This update fixes multiple buffer overflows when reading large image files, or
maliciously created image files whose headers misrepresent the actual image
size.

ChangeLog:

* Mon Aug 24 2009 Jerry James  - 21.5.28-10
- Fix image overflow bug (CVE-2009-2688).
- Add dependency on xorg-x11-fonts-misc (#478370, Carl Brune).
- Rebase patches to eliminate fuzz/offsets.

References:

[ 1 ] Bug #511994 - CVE-2009-2688 xemacs: multiple integer overflow flaws
https://bugzilla.redhat.com/show_bug.cgi?id=511994

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update xemacs' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8997

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8997 (xemacs)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"xemacs", rpm:"xemacs~21.5.28~10.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xemacs-common", rpm:"xemacs-common~21.5.28~10.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xemacs-devel", rpm:"xemacs-devel~21.5.28~10.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xemacs-el", rpm:"xemacs-el~21.5.28~10.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xemacs-info", rpm:"xemacs-info~21.5.28~10.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xemacs-nox", rpm:"xemacs-nox~21.5.28~10.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xemacs-debuginfo", rpm:"xemacs-debuginfo~21.5.28~10.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
