# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8498 (libxml2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64626);
 script_cve_id("CVE-2009-2414", "CVE-2009-2416");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Fedora Core 11 FEDORA-2009-8498 (libxml2)");

 desc = "The remote host is missing an update to libxml2
announced via advisory FEDORA-2009-8498.

Update Information:

Two patches for parsing problems raised by Ficora

ChangeLog:

* Mon Aug 10 2009 Daniel Veillard  - 2.7.3-3
- two patches for parsing problems CVE-2009-2414 and CVE-2009-2416

References:

[ 1 ] Bug #515195 - CVE-2009-2414 libxml, libxml2: Stack overflow by parsing root XML element DTD definition
https://bugzilla.redhat.com/show_bug.cgi?id=515195
[ 2 ] Bug #515205 - CVE-2009-2416 libxml, libxml2: Pointer use-after-free flaws by parsing Notation and Enumeration attribute types
https://bugzilla.redhat.com/show_bug.cgi?id=515205

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update libxml2' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8498

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8498 (libxml2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"libxml2", rpm:"libxml2~2.7.3~3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-devel", rpm:"libxml2-devel~2.7.3~3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-python", rpm:"libxml2-python~2.7.3~3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-static", rpm:"libxml2-static~2.7.3~3.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libxml2-debuginfo", rpm:"libxml2-debuginfo~2.7.3~3.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
