# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-10344 (aria2)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(65743);
 script_cve_id("CVE-2009-3575");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Fedora Core 10 FEDORA-2009-10344 (aria2)");

 desc = "The remote host is missing an update to aria2
announced via advisory FEDORA-2009-10344.

Update Information:

Fixes CVE-2009-3575, A buffer overflow vulnerability described in more detail at
https://bugzilla.redhat.com/show_bug.cgi?id=527827

ChangeLog:

* Thu Oct  8 2009 Rahul Sundaram  - 1.3.1-2
- Fix spec. Dumb mistake
* Thu Oct  8 2009 Rahul Sundaram  - 1.3.1-1
- Update to the same version as Fedora 11 that fixes rhbz#52782

References:

[ 1 ] Bug #527827 - CVE-2009-3575 aria2: buffer overflow vulnerability
https://bugzilla.redhat.com/show_bug.cgi?id=527827

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update aria2' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-10344

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-10344 (aria2)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"aria2", rpm:"aria2~1.3.1~2.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"aria2-debuginfo", rpm:"aria2-debuginfo~1.3.1~2.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
