# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 788-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55190);
 script_cve_id("CVE-2005-2626", "CVE-2005-2627");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 788-1 (kismet)";
 script_name(name);

 desc = "The remote host is missing an update to kismet
announced via advisory DSA 788-1.

Several security related problems have been discovered in kismet, a
wireless 802.11b monitoring tool.  The Common Vulnerabilities and
Exposures project identifies the following problems:

CVE-2005-2626
Insecure handling of unprintable characters in the SSID.

CVE-2005-2627
Multiple integer underflows could allow remote attackers to
execute arbitrary code.

The old stable distribution (woody) does not seem to be affected by
these problems.

For the stable distribution (sarge) these problems have been fixed in
version 2005.04.R1-1sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 2005.08.R1-1.

We recommend that you upgrade your kismet package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20788-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 788-1 (kismet)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kismet", ver:"2005.04.R1-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
