# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 547-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53236);
 script_cve_id("CVE-2004-0827");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 547-1 (imagemagic)";
 script_name(name);

 desc = "The remote host is missing an update to imagemagic
announced via advisory DSA 547-1.

Marcus Meissner from SUSE has discovered several buffer overflows in
the ImageMagick graphics library.  An attacker could create a
malicious image or video file in AVI, BMP, or DIB format that could
crash the reading process.  It might be possible that carefully
crafted images could also allow to execute arbitrary code with the
capabilities of the invoking process.

For the stable distribution (woody) this problem has been fixed in
version 5.4.4.5-1woody3.

For the unstable distribution (sid) this problem has been fixed in
version 6.0.6.2-1.

We recommend that you upgrade your imagemagick packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20547-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 547-1 (imagemagic)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"imagemagick", ver:"5.4.4.5-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++5", ver:"5.4.4.5-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick++5-dev", ver:"5.4.4.5-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick5", ver:"5.4.4.5-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmagick5-dev", ver:"5.4.4.5-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"perlmagick", ver:"5.4.4.5-1woody3", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
