# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 411-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53111);
 script_bugtraq_id(9364);
 script_cve_id("CVE-2003-0969");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 411-1 (mpg321)";
 script_name(name);

 desc = "The remote host is missing an update to mpg321
announced via advisory DSA 411-1.

A vulnerability was discovered in mpg321, a command-line mp3 player,
whereby user-supplied strings were passed to printf(3) unsafely.  This
vulnerability could be exploited by a remote attacker to overwrite
memory, and possibly execute arbitrary code.  In order for this
vulnerability to be exploited, mpg321 would need to play a malicious
mp3 file (including via HTTP streaming).

For the current stable distribution (woody) this problem has been
fixed in version 0.2.10.2.

For the unstable distribution (sid) this problem has been fixed in
version 0.2.10.3.

We recommend that you update your mpg321 package.



Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20411-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 411-1 (mpg321)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mpg321", ver:"0.2.10.2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
