# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 244-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53320);
 script_bugtraq_id(6695);
 script_cve_id("CVE-2003-0037");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 244-1 (noffle)";
 script_name(name);

 desc = "The remote host is missing an update to noffle
announced via advisory DSA 244-1.

Dan Jacobson noticed a problem in noffle, an offline news server, that
leads to a segmentation fault.  It is not yet clear whether this
problem is exploitable.  However, if it is, a remote attacker could
trigger arbitrary code execution under the user that calls noffle,
probably news.

For the stable distribution (woody) this problem has been fixed in
version 1.0.1-1.1.

The old stable distribution (potato) does not contain a noffle
package.

For the unstable distribution (sid) this problem has been fixed in
version 1.1.2-1.

We recommend that you upgrade your noffle package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20244-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 244-1 (noffle)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"noffle", ver:"1.0.1-1.1", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
