# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1901-1 (mediawiki1.7)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(65007);
 script_cve_id("CVE-2008-5249", "CVE-2008-5250", "CVE-2008-5252", "CVE-2009-0737");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1901-1 (mediawiki1.7)");

 desc = "The remote host is missing an update to mediawiki1.7
announced via advisory DSA 1901-1.


Several vulnerabilities have been discovered in mediawiki1.7, a website engine
for collaborative work. The Common Vulnerabilities and Exposures project
identifies the following problems:

CVE-2008-5249

David Remahl discovered that mediawiki1.7 is prone to a cross-site scripting attack.

CVE-2008-5250

David Remahl discovered that mediawiki1.7, when Internet Explorer is used and
uploads are enabled, or an SVG scripting browser is used and SVG uploads are
enabled, allows remote authenticated users to inject arbitrary web script or
HTML by editing a wiki page.

CVE-2008-5252

David Remahl discovered that mediawiki1.7 is prone to a cross-site request
forgery vulnerability in the Special:Import feature.

CVE-2009-0737

It was discovered that mediawiki1.7 is prone to a cross-site scripting attack in
the web-based installer.


For the oldstable distribution (etch), these problems have been fixed in version
1.7.1-9etch1 for mediawiki1.7, and mediawiki is not affected (it is a
metapackage for mediawiki1.7).

The stable (lenny) distribution does not include mediawiki1.7, and these
problems have been fixed in version 1:1.12.0-2lenny3 for mediawiki which was
already included in the lenny release.

The unstable (sid) and testing (squeeze) distributions do not
include mediawiki1.7, and these problems have been fixed in version 1:1.14.0-1
for mediawiki.


We recommend that you upgrade your mediawiki1.7 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201901-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1901-1 (mediawiki1.7)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"mediawiki1.7", ver:"1.7.1-9etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mediawiki1.7-math", ver:"1.7.1-9etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
