# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1707-1 (iceweasel)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63220);
 script_cve_id("CVE-2008-5500", "CVE-2008-5503", "CVE-2008-5504", "CVE-2008-5506", "CVE-2008-5507", "CVE-2008-5508", "CVE-2008-5510", "CVE-2008-5511", "CVE-2008-5512", "CVE-2008-5513");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1707-1 (iceweasel)";
 script_name(name);

 desc = "The remote host is missing an update to iceweasel
announced via advisory DSA 1707-1.  For details on issues
addressed in the missing update, please visit the referenced
security advisories.

For the stable distribution (etch) these problems have been fixed in
version 2.0.0.19-0etch1.

For the testing distribution (lenny) and the unstable distribution (sid)
these problems have been fixed in version 3.0.5-1. Please note iceweasel
in Lenny links dynamically against xulrunner.

We recommend that you upgrade your iceweasel package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201707-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1707-1 (iceweasel)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"iceweasel-dom-inspector", ver:"2.0.0.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox", ver:"2.0.0.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-gnome-support", ver:"2.0.0.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"mozilla-firefox-dom-inspector", ver:"2.0.0.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-dbg", ver:"2.0.0.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel-gnome-support", ver:"2.0.0.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"iceweasel", ver:"2.0.0.19-0etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
