# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1462-1 (hplip)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60177);
 script_cve_id("CVE-2007-5208");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.6");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1462-1 (hplip)";
 script_name(name);

 desc = "The remote host is missing an update to hplip
announced via advisory DSA 1462-1.

Kees Cook discovered that the hpssd tool of the HP Linux Printing and
Imaging System (HPLIP) performs insufficient input sanitising of shell
meta characters, which may result in local privilege escalation to
the hplip user.

For the unstable distribution (sid), this problem has been fixed in
version 1.6.10-4.3.

For the stable distribution (etch), this problem has been fixed in
version 1.6.10-3etch1.

The old stable distribution (sarge) is not affected by this problem.

We recommend that you upgrade your hplip packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201462-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1462-1 (hplip)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"hpijs-ppds", ver:"2.6.10+1.6.10-3etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hplip-data", ver:"1.6.10-3etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hplip-doc", ver:"1.6.10-3etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hplip-dbg", ver:"1.6.10-3etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hplip", ver:"1.6.10-3etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"hpijs", ver:"2.6.10+1.6.10-3etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
