# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1387-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58670);
 script_cve_id("CVE-2007-4743", "CVE-2007-3999");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1387-1 (librpcsecgss)";
 script_name(name);

 desc = "The remote host is missing an update to librpcsecgss
announced via advisory DSA 1387-1.

It has been discovered that the original patch for a buffer overflow in
svc_auth_gss.c in the RPCSEC_GSS RPC library in MIT Kerberos 5
(CVE-2007-3999, DSA-1368-1) was insufficient to protect from arbitrary
code execution in some environments.

The old stable distribution (sarge) does not contain a librpcseggss
package.

For the stable distribution (etch), this problem has been fixed in
version 0.14-2etch3.

For the unstable distribution (sid), this problem has been fixed in
version 0.14-4.

We recommend that you upgrade your librpcsecgss package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201387-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1387-1 (librpcsecgss)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"librpcsecgss3", ver:"0.14-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"librpcsecgss-dev", ver:"0.14-2etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
