# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 116-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53394);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 116-1 (cfs)";
 script_name(name);

 desc = "The remote host is missing an update to cfs
announced via advisory DSA 116-1.

Zorgon found several buffer overflows in cfsd, a daemon that pushes
encryption services into the Unix(tm) file system.  We are not yet
sure if these overflows can successfully be exploited to gain root
access to the machine running the CFS daemon.  However, since cfsd can
easily be forced to die, a malicious user can easily perform a denial
of service attack to it.

This problem has been fixed in version 1.3.3-8.1 for the stable Debian
distribution and in version 1.4.1-5 for the testing and undtable
distribution of Debian.

We recommend that you upgrade your cfs package immediately.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20116-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 116-1 (cfs)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"cfs", ver:"1.3.3-8.1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
