# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 071-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53821);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 071-1 (fetchmail)";
 script_name(name);

 desc = "The remote host is missing an update to fetchmail
announced via advisory DSA 071-1.

Salvatore Sanfilippo found two remotely exploitable problems in
fetchmail while doing a security audit. In both the imap and pop3 code
the input is not verified and used to store a number in an array. Since
no bounds checking is done this can be used by an attacker to write
arbitrary data in memory. An attacker can use this if we can get a user
to transfer mail from a custom imap or pop3 server he controls.

This has been fixed in version 5.3.3-3.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20071-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 071-1 (fetchmail)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"fetchmailconf", ver:"5.3.3-3", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"fetchmail", ver:"5.3.3-3", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
