# OpenVAS Vulnerability Test include file
# $Id$
# Description: Check if debian package is up to date
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License Version 2
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
# isdpkgvuln is intended to provide a quick way to verify that
# a given rpm, if it is installed, is vulnerable or not. The function
# isdpkgvuln returns 0 if it is not installed or is installed
# but up to date, and returns 1 if it is installed and vulnerable

# dpkg gives us the package name and version number nicely separated out.
function isdpkgvuln(pkg, ver, rls) {
    local_var kbrls, rpms, pat, matches, rc;

    # Check that we have the data for this release.
    kbrls = get_kb_item("ssh/login/release");
    if(kbrls!=rls) {
	return(0);
    }
    rpms = get_kb_item("ssh/login/packages");
    if(!rpms) return(0);
    pat = string("ii  (", pkg, ") +([^ ]+)");
    matches = eregmatch(pattern:pat, string:rpms);
    if(isnull(matches)) {
	return(0);
    }
    rc = revcomp(a:matches[2], b:ver);
    if(rc<0) {
	security_note(0, data: "Package " + pkg + " version " +
		matches[2] + " is installed which is known to be vulnerable.");
	return(1);
    }
    return(0);
}
