##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/03/23
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from parser import ubuntu


class UbuntuParserTestCase(unittest.TestCase):

    ## Initial Setup
    ubuntu_parser_obj = ubuntu.Parser()

    def setUp(self):
        ptr = open('./test/unit_test/work/input/ubuntu-000696.html', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.ubuntu_parser_obj, 'Html_content', self.Html_content)


    def test_getCVE(self):
        print "\nTesting Ubuntu Parser Test Suite ..."
        req_out_put = 'CVE-2008-1722'

        out_put = self.ubuntu_parser_obj.getCVE()
        self.assertEquals(out_put, req_out_put)


    def test_getAdvID(self):
        req_out_put = 'USN-606-1'

        out_put = self.ubuntu_parser_obj.getAdvID()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedPackage(self):
        req_out_put = 'cupsys vulnerability'

        out_put = self.ubuntu_parser_obj.getAffectedPackage()
        self.assertEquals(out_put, req_out_put)


    def test_getDescription(self):
        req_out_put = "Thomas Pollet discovered that CUPS did not properly validate the size of\n  PNG images. A local attacker, and a remote attacker if printer sharing\n  is enabled, could send a crafted file and cause a denial of service or\n  possibly execute arbitrary code as the non-root user in Ubuntu 6.06 LTS\n  and 7.04. In Ubuntu 7.10, attackers would be isolated by the AppArmor\n  CUPS profile. (CVE-2008-1722)" 

        out_put = self.ubuntu_parser_obj.getDescription()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct(self):
        req_out_put = ['Ubuntu 6.06 LTS', 'Ubuntu 7.04', 'Ubuntu 7.10']

        out_put = self.ubuntu_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getRPM(self):
        req_out_put = {'UBUNTU6.06 LTS': ['cupsys-bsd_1.2.2-0ubuntu0.6.06.9', 'cupsys-client_1.2.2-0ubuntu0.6.06.9', 'cupsys_1.2.2-0ubuntu0.6.06.9', 'libcupsimage2-dev_1.2.2-0ubuntu0.6.06.9', 'libcupsimage2_1.2.2-0ubuntu0.6.06.9', 'libcupsys2-dev_1.2.2-0ubuntu0.6.06.9', 'libcupsys2_1.2.2-0ubuntu0.6.06.9', 'libcupsys2-gnutls10_1.2.2-0ubuntu0.6.06.9'], 'UBUNTU7.04': ['cupsys-bsd_1.2.8-0ubuntu8.4', 'cupsys-client_1.2.8-0ubuntu8.4', 'cupsys_1.2.8-0ubuntu8.4', 'libcupsimage2-dev_1.2.8-0ubuntu8.4', 'libcupsimage2_1.2.8-0ubuntu8.4', 'libcupsys2-dev_1.2.8-0ubuntu8.4', 'libcupsys2_1.2.8-0ubuntu8.4', 'cupsys-common_1.2.8-0ubuntu8.4'], 'UBUNTU7.10': ['cupsys-bsd_1.3.2-1ubuntu7.7', 'cupsys-client_1.3.2-1ubuntu7.7', 'cupsys_1.3.2-1ubuntu7.7', 'libcupsimage2-dev_1.3.2-1ubuntu7.7', 'libcupsimage2_1.3.2-1ubuntu7.7', 'libcupsys2-dev_1.3.2-1ubuntu7.7', 'libcupsys2_1.3.2-1ubuntu7.7', 'cupsys-common_1.3.2-1ubuntu7.7']}

        prod_list = ['Ubuntu 6.06 LTS', 'Ubuntu 7.04', 'Ubuntu 7.10']
        out_put = self.ubuntu_parser_obj.getRPM(prod_list)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference1(self):
        req_out_put = 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-May/000696.html'

        main_url = 'https://lists.ubuntu.com/archives/ubuntu-security-announce/'
        file_name = '2008-May_000696.html'
        out_put = self.ubuntu_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference2(self):
        req_out_put = 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-May/000696.html'

        main_url = 'https://lists.ubuntu.com/archives/ubuntu-security-announce'
        file_name = '2008-May_000696.html'
        out_put = self.ubuntu_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_parser(self):
        req_out_put = True

        prod_list = ['Ubuntu 6.06 LTS', 'Ubuntu 7.04', 'Ubuntu 7.10']
        setattr(self.ubuntu_parser_obj, 'Platforms', prod_list)
        out_put = self.ubuntu_parser_obj.parser(self.Html_content)
        self.assertEquals(out_put, req_out_put)


    def test_getYearLinks(self):
        req_out_put = ['https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-December/thread.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/thread.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-October/thread.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-September/thread.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-August/thread.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-July/thread.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-June/thread.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-May/thread.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-April/thread.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-March/thread.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-February/thread.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-January/thread.html']

        link = './test/unit_test/work/input/ubuntu-advisory-main.html'
        year = '2008'
        out_put = self.ubuntu_parser_obj._getYearLinks(link, year)
        self.assertEquals(out_put, req_out_put)


    def test_getEachAdvLink(self):
        req_out_put = ['https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000696.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000697.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000698.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000699.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000700.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000701.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000702.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000703.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000704.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000705.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000706.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000707.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000708.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000709.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000710.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000711.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000712.html', 'https://lists.ubuntu.com/archives/ubuntu-security-announce/input/000713.html'] 

        link = './test/unit_test/work/input/Ubuntu-May-2008.html'
        out_put = self.ubuntu_parser_obj._getEachAdvLink(link)
        self.assertEquals(out_put, req_out_put)


if __name__ == '__main__':
    unittest.main()

