/*
 * Copyright (c) 2013, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

package com.oracle.chess.protocol;

import java.util.ArrayList;
import java.util.List;

/**
 * QueryGamesRsp class.
 *
 */
public class QueryGamesRsp extends MessageRsp {

    public static class Game {
        
        private String gameId;

        private String summary;

        private boolean open;

        private String whitePlayer;

        private String blackPlayer;

        private boolean completed;

        public String getGameId() {
            return gameId;
        }

        public void setGameId(String gameId) {
            this.gameId = gameId;
        }

        public String getSummary() {
            return summary;
        }

        public void setSummary(String summary) {
            this.summary = summary;
        }

        public boolean isOpen() {
            return open;
        }

        public void setOpen(boolean open) {
            this.open = open;
        }

        public String getWhitePlayer() {
            return whitePlayer;
        }

        public void setWhitePlayer(String whitePlayer) {
            this.whitePlayer = whitePlayer;
        }

        public String getBlackPlayer() {
            return blackPlayer;
        }

        public void setBlackPlayer(String blackPlayer) {
            this.blackPlayer = blackPlayer;
        }

        public boolean isCompleted() {
            return completed;
        }

        public void setCompleted(boolean completed) {
            this.completed = completed;
        }
    };

    private List<Game> games = new ArrayList<>();

    public QueryGamesRsp() {
    }

    public QueryGamesRsp(String gameId) {
        super(gameId);
    }

    public void addGame(Game game) {
        if (games == null) {
            games = new ArrayList<>();
        }
        games.add(game);
    }
    
    public List<Game> getGames() {
        return games;
    }

    public void setGames(List<Game> games) {
        this.games = games;
    }

    @Override
    public void processMe(ClientMessageProcessor processor) {
        processor.process(this);
    }

}
