/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _GTLIMAGEIO_IMAGE_DC_REGISTRY_H_
#define _GTLIMAGEIO_IMAGE_DC_REGISTRY_H_

#include <GTLCore/String.h>

#include <GTLImageIO/Export.h>

namespace GTLImageIO {
  class ImageDC;
  /**
   * This is a registry of all \ref ImageDC coder/decoder that are available.
   * 
   * @ingroup GTLImageIO
   */
  class GTLIMAGEIO_EXPORT ImageDCRegistry {
      ImageDCRegistry();
      virtual ~ImageDCRegistry();
      void initialise();
    public:
      /**
       * @return the registry instance.
       */
      static ImageDCRegistry* instance();
      /**
       * Filter for use in dialogs for the list of all image types that can be
       * decoded.
       */
      const GTLCore::String& decodableFilter() const;
      /**
       * Filter for use in dialogs for the list of all image types that can be
       * encoded.
       */
      const GTLCore::String& encodableFilter() const;
      /**
       * Add a \ref ImageDC to the registry.
       */
      void registerDC( ImageDC* _imageDC );
      /**
       * Find the decoder for the given image.
       */
      const ImageDC* decoder( const GTLCore::String& _fileName ) const;
      /**
       * Find the encoder for the given image.
       */
      const ImageDC* encoder( const GTLCore::String& _fileName ) const;
    private:
      struct Private;
      Private* const d;
  };
}

#endif
